/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentInstrument;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.JSONInstrumentDefinition;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;

public class GUIHUD
extends AGUIBase {
    private static final int HUD_WIDTH = 400;
    private static final int HUD_HEIGHT = 140;
    private static final ControlSystem.ControlsKeyboard[] customKeybindControls = new ControlSystem.ControlsKeyboard[]{ControlSystem.ControlsKeyboard.GENERAL_CUSTOM1, ControlSystem.ControlsKeyboard.GENERAL_CUSTOM2, ControlSystem.ControlsKeyboard.GENERAL_CUSTOM3, ControlSystem.ControlsKeyboard.GENERAL_CUSTOM4};
    private final EntityVehicleF_Physics vehicle;
    private final PartSeat seat;
    private final List<GUIComponentInstrument> instruments = new ArrayList<GUIComponentInstrument>();
    private GUIComponentLabel healthLabel;
    private Map<Byte, GUIComponentLabel> customKeybindLabels = new HashMap<Byte, GUIComponentLabel>();
    private Map<Byte, Set<String>> customKeybindNames = new HashMap<Byte, Set<String>>();
    private boolean halfHUDActive;

    public GUIHUD(EntityVehicleF_Physics vehicle, PartSeat seat) {
        this.vehicle = vehicle;
        this.seat = seat;
        this.halfHUDActive = ((JSONVehicle)vehicle.definition).motorized.halfHUDOnly || !((JSONVehicle)vehicle.definition).motorized.fullHUDOnly && (InterfaceManager.clientInterface.getCameraMode() == CameraSystem.CameraMode.FIRST_PERSON ? (Boolean)ConfigSystem.client.renderingSettings.fullHUD_1P.value == false : (Boolean)ConfigSystem.client.renderingSettings.fullHUD_3P.value == false);
    }

    @Override
    public void setupComponents() {
        if (this.seat.placementDefinition.isController) {
            if (this.halfHUDActive) {
                this.guiTop += this.getHeight() / 2;
            }
            super.setupComponents();
            this.instruments.clear();
            for (int i = 0; i < this.vehicle.instruments.size(); ++i) {
                if (this.vehicle.instruments.get(i) == null || ((JSONInstrumentDefinition)((JSONVehicle)this.vehicle.definition).instruments.get((int)i)).placeOnPanel) continue;
                GUIComponentInstrument instrument = new GUIComponentInstrument(this.guiLeft, this.guiTop, this.vehicle, i);
                this.instruments.add(instrument);
                this.addComponent(instrument);
            }
            for (APart part2 : this.vehicle.parts) {
                for (int i = 0; i < part2.instruments.size(); ++i) {
                    if (part2.instruments.get(i) == null || ((JSONInstrumentDefinition)((JSONPart)part2.definition).instruments.get((int)i)).placeOnPanel) continue;
                    GUIComponentInstrument instrument = new GUIComponentInstrument(this.guiLeft, this.guiTop, part2, i);
                    this.instruments.add(instrument);
                    this.addComponent(instrument);
                }
            }
            if (this.halfHUDActive) {
                this.guiTop -= this.getHeight() / 2;
            }
        } else {
            super.setupComponents();
        }
        this.healthLabel = new GUIComponentLabel(this.screenWidth, 8, ColorRGB.WHITE, "", RenderText.TextAlignment.RIGHT_ALIGNED, 1.0f);
        this.addComponent(this.healthLabel);
        this.healthLabel.ignoreGUILightingState = true;
        this.customKeybindLabels.clear();
        this.populateKeybindLabel(this.vehicle);
        this.vehicle.allParts.forEach(part -> this.populateKeybindLabel((AEntityE_Interactable<?>)part));
    }

    private void populateKeybindLabel(AEntityE_Interactable<?> entity) {
        if (((AJSONInteractableEntity)entity.definition).customKeybinds != null) {
            ((AJSONInteractableEntity)entity.definition).customKeybinds.forEach(customKeybind -> {
                if (!this.customKeybindLabels.containsKey(customKeybind.keyIndex)) {
                    GUIComponentLabel keybindLabel = new GUIComponentLabel(this.screenWidth, 16 + 8 * this.customKeybindLabels.size(), ColorRGB.WHITE, "" + customKeybind.name, RenderText.TextAlignment.RIGHT_ALIGNED, 1.0f);
                    this.addComponent(keybindLabel);
                    this.customKeybindLabels.put(customKeybind.keyIndex, keybindLabel);
                }
                this.customKeybindNames.computeIfAbsent(customKeybind.keyIndex, f -> new HashSet()).add(customKeybind.name);
            });
        }
    }

    @Override
    public void setStates() {
        if (this.halfHUDActive ^ (((JSONVehicle)this.vehicle.definition).motorized.halfHUDOnly || !((JSONVehicle)this.vehicle.definition).motorized.fullHUDOnly && (InterfaceManager.clientInterface.getCameraMode() == CameraSystem.CameraMode.FIRST_PERSON ? (Boolean)ConfigSystem.client.renderingSettings.fullHUD_1P.value == false : (Boolean)ConfigSystem.client.renderingSettings.fullHUD_3P.value == false))) {
            this.halfHUDActive = !this.halfHUDActive;
            this.setupComponents();
        }
        super.setStates();
        for (GUIComponentInstrument instrument : this.instruments) {
            instrument.visible = CameraSystem.customCameraOverlay == null && this.seat.placementDefinition.isController && (InterfaceManager.clientInterface.getCameraMode() == CameraSystem.CameraMode.FIRST_PERSON ? (Boolean)ConfigSystem.client.renderingSettings.renderHUD_1P.value : (Boolean)ConfigSystem.client.renderingSettings.renderHUD_3P.value) != false;
        }
        this.healthLabel.text = String.format("Health: %d/%d", (int)Math.ceil((double)((JSONVehicle)this.vehicle.definition).general.health - this.vehicle.damageVar.currentValue), ((JSONVehicle)this.vehicle.definition).general.health);
        this.healthLabel.visible = this.seat.placementDefinition.isController || this.seat.canControlGuns;
        this.healthLabel.color = this.vehicle.outOfHealth ? ColorRGB.RED : ColorRGB.WHITE;
        this.customKeybindLabels.entrySet().forEach(entry -> {
            byte keyIndex = (Byte)entry.getKey();
            GUIComponentLabel label = (GUIComponentLabel)entry.getValue();
            label.text = InterfaceManager.inputInterface.getNameForKeyCode(GUIHUD.customKeybindControls[keyIndex - 1].config.keyCode) + "->";
            this.customKeybindNames.get(keyIndex).forEach(name -> {
                if (!label.text.endsWith(">")) {
                    label.text = label.text + ", ";
                }
                label.text = label.text + name;
            });
        });
    }

    @Override
    protected boolean renderBackground() {
        return CameraSystem.customCameraOverlay == null && this.seat.placementDefinition.isController && (InterfaceManager.clientInterface.getCameraMode() == CameraSystem.CameraMode.FIRST_PERSON ? (Boolean)ConfigSystem.client.renderingSettings.renderHUD_1P.value != false && (Boolean)ConfigSystem.client.renderingSettings.transpHUD_1P.value == false : (Boolean)ConfigSystem.client.renderingSettings.renderHUD_3P.value != false && (Boolean)ConfigSystem.client.renderingSettings.transpHUD_3P.value == false);
    }

    @Override
    protected AGUIBase.GUILightingMode getGUILightMode() {
        return this.vehicle.renderTextLit() ? AGUIBase.GUILightingMode.LIT : AGUIBase.GUILightingMode.DARK;
    }

    @Override
    protected EntityVehicleF_Physics getGUILightSource() {
        return this.vehicle;
    }

    @Override
    public boolean capturesPlayer() {
        return false;
    }

    @Override
    protected boolean canStayOpen() {
        return super.canStayOpen() && this.seat.rider != null;
    }

    @Override
    public int getWidth() {
        return 400;
    }

    @Override
    public int getHeight() {
        return 140;
    }

    @Override
    public boolean renderFlushBottom() {
        return true;
    }

    @Override
    public boolean renderTranslucent() {
        return true;
    }

    @Override
    protected String getTexture() {
        return ((JSONVehicle)this.vehicle.definition).motorized.hudTexture != null ? ((JSONVehicle)this.vehicle.definition).motorized.hudTexture : "mts:textures/guis/hud.png";
    }
}

